//Cylinder Parameters
r_cyl = 0.5;
x = r_cyl *Sin(Pi/4);

//Control Cylinder Parameters
d = 0.6;
r_ccyl = 0.05;
angle = Pi/3;
xc = d * Cos(angle);
yc = d * Sin(angle);

xc_ = (d+r_ccyl) * Cos(Pi/4);
_xc = (d-r_ccyl) * Cos(Pi/4);


//Domain Size
L = 5;  //Square domain of the cylinder
L_ext = 15; //Domain for the shedding area

//Control Domain Box
c_sq = L/8;

// Mesh Control
Nx1 = 20; Nx2 = 50;
V1 = 20; V2 = 40; Loop = 50; P1 = 1; P2 = 1.05;
main_cylinder_mesh_factor = 0.01;
control_cylinder_mesh_factor = 0.01;


 ///// ----------- //////
//+
Point(1) = {-L, -L, 0, 1.0};
//+
Point(2) = {L, -L, 0, 1.0};
//+
Point(3) = {L_ext, -L, 0, 1.0};
//+
Point(4) = {-L, L, 0, 1.0};
//+
Point(5) = {L, L, 0, 1.0};
//+
Point(6) = {L_ext, L, 0, 1.0};

//Cylinder
//+
Point(7) = {-x, -x, 0, main_cylinder_mesh_factor};
//+
Point(8) = {x, -x, 0, main_cylinder_mesh_factor};
//+
Point(9) = {-x, x, 0, main_cylinder_mesh_factor};
//+
Point(10) = {x, x, 0, main_cylinder_mesh_factor};
//+
Point(11) = {0, 0, 0, 1.0};
//+
Point(12) = {xc, yc, 0, 1.0};   //top center
//+
Point(13) = {xc, yc + r_ccyl, 0, control_cylinder_mesh_factor};
//+
Point(14) = {xc, yc - r_ccyl, 0, control_cylinder_mesh_factor};
//+
Point(15) = {xc + r_ccyl, yc, 0, control_cylinder_mesh_factor};
//+
Point(16) = {xc - r_ccyl, yc, 0, control_cylinder_mesh_factor};
//+
Point(22) = {xc, -yc, 0, 1.0};  //bottom center
//+
Point(23) = {xc, -yc + r_ccyl, 0, control_cylinder_mesh_factor};
//+
Point(24) = {xc, -yc - r_ccyl, 0, control_cylinder_mesh_factor};
//+
Point(25) = {xc + r_ccyl, -yc , 0, control_cylinder_mesh_factor};
//+
Point(26) = {xc - r_ccyl, -yc , 0, control_cylinder_mesh_factor};
/////////// Unstructured mesh region
//+

Unstructured_mesh_refinement_factor = 0.01;
Point(18) = {c_sq, c_sq, 0, Unstructured_mesh_refinement_factor};
//+
Point(19) = {c_sq, -c_sq, 0, Unstructured_mesh_refinement_factor};
//+
Point(20) = {-c_sq, -c_sq, 0, Unstructured_mesh_refinement_factor};
//+
Point(21) = {-c_sq, c_sq, 0, Unstructured_mesh_refinement_factor};

/////// ------- Lines ------- ///////
////+
Line(1) = {1, 2};
//+
Line(2) = {2, 3};
//+
Line(3) = {3, 6};
//+
Line(4) = {5, 6};
//+
Line(5) = {5, 4};
//+
Line(6) = {4, 1};
//+
Line(7) = {5, 2};
//+
Line(8) = {20, 19};
//+
Line(9) = {19, 18};
//+
Line(10) = {18, 21};
//+
Line(11) = {21, 20};
//+
Line(12) = {20, 1};
//+
Line(13) = {19, 2};
//+
Line(14) = {18, 5};
//+
Line(15) = {21, 4};
//+
Circle(16) = {10, 11, 9};
//+
Circle(17) = {9, 11, 7};
//+
Circle(18) = {7, 11, 8};
//+
Circle(19) = {8, 11, 10};
//+
Circle(20) = {15, 12, 13};
//+
Circle(21) = {13, 12, 16};
//+
Circle(22) = {16, 12, 14};
//+
Circle(23) = {14, 12, 15};
//+
Circle(24) = {23, 22, 26};
//+
Circle(25) = {26, 22, 24};
//+
Circle(26) = {24, 22, 25};
//+
Circle(27) = {25, 22, 23};

/////// ------- Geometry Ends Here ------- ///////

/////// ------- Create Surface Geometry ------- ///////
//+
Curve Loop(1) = {8, 13, -1, -12};
//+
Plane Surface(1) = {1};
//+
Curve Loop(2) = {12, -6, -15, 11};
//+
Plane Surface(2) = {2};
//+
Curve Loop(3) = {15, -5, -14, 10};
//+
Plane Surface(3) = {3};
//+
Curve Loop(4) = {14, 7, -13, 9};
//+
Plane Surface(4) = {4};
//+
Curve Loop(5) = {7, 2, 3, -4};
//+
Plane Surface(5) = {5};
//+
Curve Loop(6) = {10, 11, 8, 9};
//+
Curve Loop(7) = {19, 16, 17, 18};
//+
Curve Loop(8) = {23, 20, 21, 22};
//+
Curve Loop(9) = {27, 24, 25, 26};
//+
Plane Surface(6) = {6, 7, 8, 9};

/////// ------- Transfinite Meshing ------- ///////

//+
Transfinite Curve {6, 11} = V1 Using Progression 1;
//+
Transfinite Curve {1, 8, 10, 5} = Nx1 Using Progression 1;
//+
Transfinite Curve {9, 7, 3} = V2 Using Progression 1;
//+
Transfinite Curve {4, 2} = Nx2 Using Progression P2;
//+
Transfinite Curve {13, 14, 15, 12} = Loop Using Progression P1;
//+
///Mesh at the Cylinder
Transfinite Curve {35, 34, 33, 36} = 50 Using Progression 1;

/////// ------- Transfinite Surfaces ------- ///////
//+
Transfinite Surface {2};
//+
Transfinite Surface {3};
//+
Transfinite Surface {4};
//+
Transfinite Surface {1};
//+
Transfinite Surface {5};
//+
Recombine Surface {2, 4, 3, 1, 5};

/////// ------- Extrude Geometry ------- ///////

// //+
Extrude {0, 0, 1} {
    Surface{6}; Surface{2}; Surface{3}; Surface{1}; Surface{4}; Surface{5}; 
    Layers{1}; 
    Recombine;
  }  



/////// ------- Physical Faces and Volume ------- ///////
//+
//+
Physical Surface("inlet") = {122};
//+
Physical Surface("outlet") = {214};
//+
Physical Surface("frontAndBack") = {131, 153, 197, 175, 2, 3, 4, 1, 109, 6, 219, 5};
//+
Physical Surface("topAndBottom") = {144, 218, 170, 210};
//+
Physical Surface("mainCylinder") = {68, 64, 76, 72};
//+
Physical Surface("bottomControlCylinder") = {104, 108, 96, 100};
//+
Physical Surface("topControlCylinder") = {84, 88, 92, 80};
//+
Physical Volume("internal") = {2, 3, 5, 4, 6, 1};
